/*************************************************************************************/
/* Pprava situace																	 */
/*************************************************************************************/

USE TechEd2012Goran
DROP FUNCTION dbo.GetPocetSchvalenychHodinPracovnika
GO

SET STATISTICS TIME ON
SET STATISTICS IO ON
-- Execution plans

/*************************************************************************************/
/* dkov funkce																	 */
/*************************************************************************************/

-- Najdi pracovnky, kte maj 100 a vce schvlench hodin
-- Funkce pro zjitn potu schvlench hodin pracovnka
CREATE FUNCTION dbo.GetPocetSchvalenychHodinPracovnika
	(@PracovnikID int)
RETURNS int
AS
BEGIN
	DECLARE @Result int
	SELECT @Result = SUM(PocetHodin)
				FROM TimesheetItem
				WHERE 
					(TimesheetItem.SchvalenoKdy IS NOT NULL)
					AND (TimesheetItem.PracovnikID = @PracovnikID)
	RETURN @Result
END
GO

-- Podmnku vyhodnocujeme pro kadho pracovnka (row-based function)
DBCC DROPCLEANBUFFERS 
SELECT PracovnikID, KrestniJmeno FROM Pracovnik
	WHERE dbo.GetPocetSchvalenychHodinPracovnika(PracovnikID) >= 100

GO

DROP FUNCTION dbo.GetPocetSchvalenychHodinPracovnika



/*************************************************************************************/
/* Set-based dotaz (pracovnk je mezi pracovnky, kte...							 */
/*************************************************************************************/
				
-- Najdi pracovnky, kte maj 100 a vce schvlench hodin
-- Jin zpis, podmnku vyhodnocujeme hromadn (set-based)				
DBCC DROPCLEANBUFFERS 
SELECT PracovnikID, KrestniJmeno FROM Pracovnik
	-- obvykle JOINy na dal detaily
	WHERE PracovnikID IN
		(SELECT TimesheetItem.PracovnikID
			FROM TimesheetItem
			WHERE 
				(TimesheetItem.SchvalenoKdy IS NOT NULL)
			GROUP BY TimesheetItem.PracovnikID
			HAVING SUM(PocetHodin) > 100)
GO


/*************************************************************************************/
/* dkov subdotaz (poddotaz je zvisl na hodnot z dku)						 */
/*************************************************************************************/

-- Najdi pracovnky, kte maj 100 a vce schvlench hodin
-- Podmnku vyhodnocujeme pro kadho pracovnka (row-based)
DBCC DROPCLEANBUFFERS 
SELECT PracovnikID, KrestniJmeno FROM Pracovnik
	WHERE 100 <= (
		SELECT SUM(PocetHodin)
			FROM TimesheetItem
			WHERE 
				(TimesheetItem.SchvalenoKdy IS NOT NULL)
				AND (TimesheetItem.PracovnikID = Pracovnik.PracovnikID))
GO
	

